/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.creativeitem;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemInfinite
extends TileBlockEntityCyclic {
    ItemStackHandler inputSlots = new ItemStackHandler(1);
    ItemStackHandler outputSlot = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlot);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileItemInfinite(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.ITEM_INFINITE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileItemInfinite e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileItemInfinite e) {
        e.tick();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public Component getDisplayName() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public void tick() {
        ItemStack stackHere = this.inputSlots.getStackInSlot(0);
        if (!stackHere.m_41619_()) {
            this.outputSlot.insertItem(0, stackHere.m_41777_(), false);
        }
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

